$(document).ready(function(){
    const $mainSlider = $('.main-slider');
    const $categoryNav = $('.category-navigation span');
    const $currentTitle = $('#currentTitle');

    // Initialize Slick Carousel
    $mainSlider.slick({
        centerMode: true,
        centerPadding: '100px', // Adjust padding around center slide
        slidesToShow: 3,        // Show 3 slides at desktop
        arrows: false,          // Hide default Slick arrows
        dots: false,            // Hide default Slick dots
        infinite: true,         // Loop the slider
        initialSlide: 3,        // Start on "FLORIST PICKS"
        responsive: [
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 3,
                    centerPadding: '80px',
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1, // Show 1 slide on smaller screens
                    centerPadding: '40px', // Smaller padding for mobile
                }
            },
            {
                breakpoint: 480,
                settings: {
                    slidesToShow: 1,
                    centerPadding: '20px',
                }
            }
        ]
    });

    // Custom Arrow Navigation
    $('.prev-arrow').on('click', function() {
        $mainSlider.slick('slickPrev');
    });

    $('.next-arrow').on('click', function() {
        $mainSlider.slick('slickNext');
    });

    // Category Navigation Click - Updates title and active category
    $categoryNav.on('click', function() {
        const index = $(this).data('index');
        const label = $(this).text().trim();

        // Remove 'active' from all and add to clicked one
        $categoryNav.removeClass('active');
        $(this).addClass('active');

        // Scroll category into view
        $(this)[0].scrollIntoView({
            behavior: 'smooth',
            inline: 'center'
        });

        // Update the central title when a category is clicked
        $currentTitle.text(label);

        // Go to the corresponding slide
        $mainSlider.slick('slickGoTo', index);
    });

    // Update Category and Title on Slide Change (via drag or arrow clicks)
    $mainSlider.on('afterChange', function(event, slick, currentSlide) {
        const currentLabel = $mainSlider.find('.slick-current .slide').data('label');

        // Restore: Update the central title when the slider moves (drag/arrows)
        $currentTitle.text(currentLabel);

        // Update active category in navigation
        $categoryNav.removeClass('active');
        $categoryNav.each(function() {
            if ($(this).text().trim() === currentLabel) {
                $(this).addClass('active');
                // Scroll active category into view
                $(this)[0].scrollIntoView({
                    behavior: 'smooth',
                    inline: 'center'
                });
            }
        });
    });
});