<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
</head>
<body>
    <?php
    // Custom Post Type Loop - Assuming a custom post type 'my_custom_post_type'
    if ( have_posts() ) :
        while ( have_posts() ) : the_post();
            // Get the image ID from the ACF custom field (replace 'featured_image' with your ACF field name)
            $image_id = get_field('featured_image'); // Change 'featured_image' to your actual field name
            if ( $image_id ) :
                // Get the image URL in full size (you can also use 'full' in wp_get_attachment_image_url())
                $image_url = wp_get_attachment_image_url( $image_id, 'full' );
                // Get the alt text of the image (useful for SEO)
                $alt_text = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
                ?>
                <div class="custom-post">
                    <h2><?php the_title(); ?></h2>
                    <div class="post-content">
                        <!-- Responsive image -->
                        <img 
                            src="<?php echo esc_url( $image_url ); ?>"  <!-- Default image for browsers without srcset support -->
                            srcset="
                                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-small' ) ); ?> 320w,
                                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-medium' ) ); ?> 640w,
                                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-large' ) ); ?> 1280w,
                                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-xlarge' ) ); ?> 1920w,
                                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-xxlarge' ) ); ?> 2560w,
                                <?php echo esc_url( wp_get_attachment_image_url( $image_id, 'responsive-4k' ) ); ?> 3840w
                            "
                            sizes="
                                (max-width: 480px) 320px,   /* Mobile */
                                (max-width: 768px) 640px,   /* Tablet */
                                (max-width: 1280px) 1280px, /* Desktop */
                                (max-width: 1920px) 1200px, /* Larger desktop */
                                1600px                      /* For larger/4K displays */
                            "
                            alt="<?php echo esc_attr( $alt_text ); ?>"  <!-- Alt text for the image -->
                            loading="lazy"
                            decoding="async"
                        />
                    </div>
                </div>
                <?php
            endif; // Check if image exists
        endwhile;
    endif;
    ?>
    

</body>
</html>