<?php
// Enqueue parent and child theme styles
function my_theme_enqueue_styles() {
    $parent_style = 'storefront-style'; // This is 'storefront-style' for Storefront theme.

    wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
    wp_enqueue_style('child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array($parent_style),
        wp_get_theme()->get('Version')
    );
}
add_action('wp_enqueue_scripts', 'my_theme_enqueue_styles');


function wpb_widgets_init() {
 
    register_sidebar( array(
        'name'          => 'Header top bar',
        'id'            => 'header-top-bar',
        'before_widget' => '',
        'after_widget'  => '',
       
    ) );

    register_sidebar( array(
        'name'          => 'Header Button',
        'id'            => 'header-button',
        'before_widget' => '',
        'after_widget'  => '',
       
    ) );
 
}
add_action( 'widgets_init', 'wpb_widgets_init' ); 


// function wpb_widgets_init() {
 
//     register_sidebar( array(
//         'name'          => 'Header Button',
//         'id'            => 'header-button',
//         'before_widget' => '',
//         'after_widget'  => '',
       
//     ) );
 
// }
// add_action( 'widgets_init', 'wpb_widgets_init' ); 

/**
 * Custom Nav Header Start
 */
function wpb_custom_new_menu() {
    register_nav_menus(
      array(
        'my-custom-menu' => __( 'My Custom Menu' ),
        'my-custom-menu-desktop' => __( 'My Custom Menu Desktop' ),
        'my-custom-menu1' => __( 'My Custom footer Menu 1' ),
        'my-custom-menu2' => __( 'My Custom footer Menu 2' ),
        'my-custom-menu3' => __( 'My Custom footer Menu 3' ),
        'shop-cat' => __( 'Shop category' ),
        'my-custom-top-menu' => __( 'Custom top Navigation' )
      )
    );
  }
  add_action( 'init', 'wpb_custom_new_menu' );

  function mytheme_customize_register($wp_customize) {

    $footer_section_id = 'storefront_footer';
    // Add a new section for the custom image
    $wp_customize->add_section('mytheme_custom_image_section', array(
        'title'       => __('Footer Logo', 'mytheme'),
        'priority'    => 30,
        'description' => __('Upload a Footer Logo for the theme', 'mytheme'),
    ));

    // Add the setting for the custom image
    $wp_customize->add_setting('mytheme_custom_image', array(
        'default'           => '',
        'transport'         => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize the input
    ));

    // Add the control for the custom image
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'mytheme_custom_image', array(
        'label'    => __('Footer Logo', 'mytheme'),
        'section'  => 'mytheme_custom_image_section',
        'settings' => 'mytheme_custom_image',
    )));

    $wp_customize->add_setting('mytheme_footer_company_info', array(
        'default'           => '',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_textarea_field', // Sanitize the input
    ));

    // Add the control for the custom text area in the Footer section
    $wp_customize->add_control('mytheme_footer_company_info', array(
        'label'    => __('Footer Company Info', 'mytheme'),
        'section'  => $footer_section_id,
        'settings' => 'mytheme_footer_company_info',
        'type'     => 'textarea',
    ));


    $social_platforms = array('facebook', 'twitter', 'instagram');

    foreach ($social_platforms as $platform) {
        // Add setting for each social media link
        $wp_customize->add_setting("mytheme_social_{$platform}_link", array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'esc_url_raw', // Sanitize the input
        ));

        // Add control for each social media link
        $wp_customize->add_control("mytheme_social_{$platform}_link", array(
            'label'    => __(ucfirst($platform) . ' Link', 'mytheme'),
            'section'  => $footer_section_id,
            'settings' => "mytheme_social_{$platform}_link",
            'type'     => 'url',
        ));
    }

     // Add setting for the phone number
     $wp_customize->add_setting('mytheme_contact_phone', array(
      'default'           => '',
      'transport'         => 'refresh',
      'sanitize_callback' => 'sanitize_text_field', // Sanitize the input
  ));

  // Add control for the phone number
  $wp_customize->add_control('mytheme_contact_phone', array(
      'label'    => __('Contact Phone Number', 'mytheme'),
      'section'  => $footer_section_id,
      'settings' => 'mytheme_contact_phone',
      'type'     => 'text',
  ));

  // Add setting for the email address
  $wp_customize->add_setting('mytheme_contact_email', array(
      'default'           => '',
      'transport'         => 'refresh',
      'sanitize_callback' => 'sanitize_email', // Sanitize the input
  ));

  // Add control for the email address
  $wp_customize->add_control('mytheme_contact_email', array(
      'label'    => __('Contact Email Address', 'mytheme'),
      'section'  => $footer_section_id,
      'settings' => 'mytheme_contact_email',
      'type'     => 'email',
  ));

  // Add setting for the message button link
  $wp_customize->add_setting('mytheme_contact_button_link', array(
      'default'           => '',
      'transport'         => 'refresh',
      'sanitize_callback' => 'esc_url_raw', // Sanitize the input
  ));

  // Add control for the message button link
  $wp_customize->add_control('mytheme_contact_button_link', array(
      'label'    => __('Contact Button Link', 'mytheme'),
      'section'  => $footer_section_id,
      'settings' => 'mytheme_contact_button_link',
      'type'     => 'url',
  ));
}
add_action('customize_register', 'mytheme_customize_register');




  

?>